/*
riadky 29 a  119 vrtane:
zdroj: https://cp-algorithms.com/graph/dinic.html
autori: https://github.com/e-maxx-eng/e-maxx-eng/commits/master/src/graph/dinic.md (do 20.1.2021)
        menovite:
        - Yury Semenov https://github.com/SYury
        - Naman Bhalla https://github.com/Naman-Bhalla
        - organizcia e-maxx-eng https://github.com/e-maxx-eng 
            - Jakob Kogler https://github.com/jakobkogler
licencia zdroju: CC-BT-SA-4.0 https://creativecommons.org/licenses/by-sa/4.0/legalcode
*/

/*
Tento cel sbor je licencovan pod CC-BT-SA-4.0 https://creativecommons.org/licenses/by-sa/4.0/legalcode
*/

/*
Riadky 1,2 a riadky medzi 111,125 vrtane boli pridan oproti zdroju (ten je od riadkov 29 do 119 vrtane) Adamom Struharanskm
*/

/*
Nie s iadne zruky funnosti a pouitelnosti na iaden el, a vetci autori
sa zriekaj zodpovednosti za kody vyplvajce z jeho pouitia.

There are absolutely no warranties of functionality and/or usability for any purpose,
and all authors disclaim liability for any damages resulting from its use.
*/

#ifndef DINIC
#define DINIC

#include <vector>
#include <queue>
#include <iostream>

using namespace std;

struct FlowEdge {
    int v, u;
    long long cap, flow = 0;
    FlowEdge(int v, int u, long long cap) : v(v), u(u), cap(cap) {}
};

struct Dinic {
    const long long flow_inf = 1e18;
    vector<FlowEdge> edges;
    vector<vector<int>> adj;
    int n, m = 0;
    int s, t;
    vector<int> level, ptr;
    queue<int> q;

    Dinic(int n, int s, int t) : n(n), s(s), t(t) {
        adj.resize(n);
        level.resize(n);
        ptr.resize(n);
    }

    void add_edge(int v, int u, long long cap) {
        edges.emplace_back(v, u, cap);
        edges.emplace_back(u, v, 0);
        adj[v].push_back(m);
        adj[u].push_back(m + 1);
        m += 2;
    }

    bool bfs() {
        while (!q.empty()) {
            int v = q.front();
            q.pop();
            for (int id : adj[v]) {
                if (edges[id].cap - edges[id].flow < 1)
                    continue;
                if (level[edges[id].u] != -1)
                    continue;
                level[edges[id].u] = level[v] + 1;
                q.push(edges[id].u);
            }
        }
        return level[t] != -1;
    }

    long long dfs(int v, long long pushed) {
        if (pushed == 0)
            return 0;
        if (v == t)
            return pushed;
        for (int& cid = ptr[v]; cid < (int)adj[v].size(); cid++) {
            int id = adj[v][cid];
            int u = edges[id].u;
            if (level[v] + 1 != level[u] || edges[id].cap - edges[id].flow < 1)
                continue;
            long long tr = dfs(u, min(pushed, edges[id].cap - edges[id].flow));
            if (tr == 0)
                continue;
            edges[id].flow += tr;
            edges[id ^ 1].flow -= tr;
            return tr;
        }
        return 0;
    }

    long long flow() {
        long long f = 0;
        while (true) {
            fill(level.begin(), level.end(), -1);
            level[s] = 0;
            q.push(s);
            if (!bfs())
                break;
            fill(ptr.begin(), ptr.end(), 0);
            while (long long pushed = dfs(s, flow_inf)) {
                f += pushed;
            }
        }
        return f;
    }
};



//metoda ktora iba prepise graf na dany tvar, a zavola "skutocnu" Dinicovu funkciu na danom grafe
int dinic_max_flow(std::vector<std::vector<pair<int, int>>> graph) {
    Dinic d = Dinic(graph.size(),0,graph.size()-1);
    for (int i = 0; i < graph.size(); i++) {
        for (int j = 0; j < graph.at(i).size(); j++) {
            d.add_edge(i, graph.at(i).at(j).first, graph.at(i).at(j).second);
        }
    }
    
    return d.flow();
}

#endif DINIC
